// PREMIUM START\njQuery(document).ready(function($) {\n    // Check if spdfedAnalyticsData is defined and analytics is enabled\n    if (typeof spdfedAnalyticsData !== \'undefined\' && spdfedAnalyticsData.enabled) {\n        \n        // Try to find the form. The form is added via shortcode.\n        // We need to ensure this script runs after the form is in the DOM and correctly targets it.\n        // The form has class \'spdfed-form\'.\n        var $form = $(\'.spdfed-form\');\n\n        if ($form.length) {\n            $form.on(\'submit\', function() {\n                // Basic client-side validation check for email and GDPR (if applicable)\n                // This is a preemptive check; server-side validation is still the authority.\n                var emailField = $(this).find(\'input[name=\"email\"]\');\n                var gdprCheckbox = $(this).find(\'input[name=\"gdpr\"]\');\n                var canSubmit = true;\n\n                if (emailField.length && emailField.prop(\'required\') && emailField.val().trim() === \'\') {\n                    // A more robust email validation regex could be used here if needed for client-side.\n                    // For now, just checking if it\'s empty if required.\n                    canSubmit = false;\n                }\n                // Very basic email format check - doesn\'t cover all cases but catches common mistakes\n                if (emailField.length && emailField.val().trim() !== \'\' && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(emailField.val())) {\n                     canSubmit = false;\n                }\n\n\n                if (gdprCheckbox.length && gdprCheckbox.prop(\'required\') && !gdprCheckbox.is(\':checked\')) {\n                    canSubmit = false;\n                }\n\n                if (!canSubmit) {\n                    // If basic client-side validation fails, don\'t send the analytics event yet.\n                    // The form submission will likely be blocked by the browser or handled by server-side validation feedback.\n                    return; \n                }\n\n                // Use file_name from localized data for the 'file' parameter\n                var eventData = {\n                    \'file\': spdfedAnalyticsData.file_name,\n                    \'post_id\': spdfedAnalyticsData.post_id // Keep post_id for potentially more detailed tracking\n                };\n\n                if (spdfedAnalyticsData.type === \'ga4\') {\n                    if (typeof gtag === \'function\') {\n                        // GA4 event name: 'download_pdf', parameters: { file: 'example.pdf', post_id: 123 }\n                        gtag(\'event\', spdfedAnalyticsData.event_name, eventData);\n                        // console.log(\'GA4 event sent: \', spdfedAnalyticsData.event_name, eventData);\n                    } else {\n                        // console.log(\'gtag function not found for GA4 event. Ensure GA4 is properly set up on your site.\');\n                    }\n                } else if (spdfedAnalyticsData.type === \'gtm\') {\n                    window.dataLayer = window.dataLayer || [];\n                    // GTM event: { event: 'secure_pdf_download', file: 'example.pdf', post_id: 123 }\n                    var gtmPayload = {\n                        \'event\': spdfedAnalyticsData.event_name,\n                        // Add all properties from eventData to the GTM payload\n                    };\n                    for (var key in eventData) {\n                        if (eventData.hasOwnProperty(key)) {\n                            gtmPayload[key] = eventData[key];\n                        }\n                    }\n                    dataLayer.push(gtmPayload);\n                    // console.log(\'GTM event sent: \', gtmPayload);\n                }\n            });\n        } else {\n            // console.log(\'SPDFED: Download form not found for analytics binding.\');\n        }\n    }\n});\n// PREMIUM END\n 