<?php
/**
 * Handles CSV export of download logs.
 *
 * @package coreessentials-email-gated-downloads
 */

defined('ABSPATH') || exit;

add_action(
	'admin_init',
	function () {
		// Check for export request - nonce must be sanitized and unslashed before verification
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended
		if (isset($_GET['spdfed_export']) && current_user_can('manage_options') && isset($_GET['_wpnonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'spdfed_export_nonce')) {

			global $wpdb;
			$table_name = $wpdb->prefix . 'spdfed_logs';

			// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
			if (!empty($_GET['spdfed_filter_file_log'])) {
				$file_filter = sanitize_text_field(wp_unslash($_GET['spdfed_filter_file_log']));
				// Direct query is required for custom tables, and caching is not appropriate for a data export.
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
				$rows = $wpdb->get_results(
					$wpdb->prepare(
						// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
						"SELECT submitter_name, email, file_name, downloaded_at FROM {$table_name} WHERE file_name = %s ORDER BY downloaded_at DESC",
						$file_filter
					),
					ARRAY_A
				);
			} else {
				// Direct query is required for custom tables, and caching is not appropriate for a data export.
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
				$rows = $wpdb->get_results(
					// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
					"SELECT submitter_name, email, file_name, downloaded_at FROM {$table_name} ORDER BY downloaded_at DESC",
					ARRAY_A
				);
			}

			// Set headers for CSV download.
			header('Content-Type: text/csv; charset=utf-8');
			header('Content-Disposition: attachment; filename="pdf-download-logs-' . current_time('Y-m-d') . '.csv"');
			header('Pragma: no-cache');
			header('Expires: 0');

			// phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_fopen
			$output = fopen('php://output', 'w');

			// Add UTF-8 BOM for Excel compatibility.
			// phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_fputs
			fputs($output, "\xEF\xBB\xBF");

			// Write headers, including the new 'Name' column.
			fputcsv(
				$output,
				[
					__('Name', 'coreessentials-email-gated-downloads'),
					__('Email', 'coreessentials-email-gated-downloads'),
					__('File Name', 'coreessentials-email-gated-downloads'),
					__('Downloaded At', 'coreessentials-email-gated-downloads'),
				]
			);

			// Write data.
			if ($rows) {
				foreach ($rows as $row) {
					fputcsv($output, $row);
				}
			}

			// phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_fclose
			fclose($output);
			exit;
		}
	}
);
