<?php

/**
 * Plugin Name: Email Gated Downloads
 * Description: This plugin lets you require visitors to enter their email (and optionally their name) before downloading files. Lightweight, easy to use and GDPR‑compliant
 * Version: 1.0.0
 * Plugin URI:      https://coreessentials.online/plugins-for-wordpress/coreessentials-email-gated-downloads/
 * Author:          Core Essentials
 * Author URI:      https://coreessentials.online/
 * License:         GPL2
 * License URI:     https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: coreessentials-email-gated-downloads
 * Requires at least: 5.0
 * Requires PHP: 7.4
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
if ( function_exists( 'sped_fs' ) ) {
    sped_fs()->set_basename( false, __FILE__ );
} else {
    /**
     * DO NOT REMOVE THIS IF, IT IS ESSENTIAL FOR THE
     * `function_exists` CALL ABOVE TO PROPERLY WORK.
     */
    if ( !function_exists( 'sped_fs' ) ) {
        // Create a helper function for easy SDK access.
        function sped_fs() {
            global $sped_fs;
            if ( !isset( $sped_fs ) ) {
                // Include Freemius SDK.
                require_once dirname( __FILE__ ) . '/vendor/freemius/start.php';
                $sped_fs = fs_dynamic_init( array(
                    'id'               => '20795',
                    'slug'             => 'coreessentials-email-gated-downloads',
                    'type'             => 'plugin',
                    'public_key'       => 'pk_e67f3a7337946bdebc4a6a66571f6',
                    'is_premium'       => false,
                    'premium_suffix'   => 'Premium',
                    'has_addons'       => false,
                    'has_paid_plans'   => true,
                    'is_org_compliant' => true,
                    'menu'             => array(
                        'slug'    => 'spdfed-settings',
                        'contact' => false,
                        'support' => false,
                        'parent'  => array(
                            'slug' => 'options-general.php',
                        ),
                    ),
                    'is_live'          => true,
                ) );
            }
            return $sped_fs;
        }

        // Init Freemius.
        sped_fs();
        // Signal that SDK was initiated.
        do_action( 'sped_fs_loaded' );
    }
    // Register activation hook - this needs to be in the main plugin file
    register_activation_hook( __FILE__, 'spdfed_activate_plugin' );
    // Load plugin files
    require_once plugin_dir_path( __FILE__ ) . 'includes/setup.php';
    require_once plugin_dir_path( __FILE__ ) . 'includes/file-manager.php';
    require_once plugin_dir_path( __FILE__ ) . 'includes/log-db.php';
    require_once plugin_dir_path( __FILE__ ) . 'includes/form-handler.php';
    require_once plugin_dir_path( __FILE__ ) . 'includes/admin-ui.php';
    require_once plugin_dir_path( __FILE__ ) . 'includes/shortcode.php';
    require_once plugin_dir_path( __FILE__ ) . 'includes/export.php';
}