// PREMIUM START
jQuery(document).ready(function($) {
    // Check if spdfedAnalyticsData is defined and analytics is enabled
    if (typeof spdfedAnalyticsData !== 'undefined' && spdfedAnalyticsData.enabled) {
        
        // Try to find the form. The form is added via shortcode.
        // We need to ensure this script runs after the form is in the DOM and correctly targets it.
        // The form has class 'spdfed-form'.
        var $form = $('.spdfed-form');

        if ($form.length) {
            $form.on('submit', function() {
                // Basic client-side validation check for email and GDPR (if applicable)
                // This is a preemptive check; server-side validation is still the authority.
                var emailField = $(this).find('input[name="email"]');
                var gdprCheckbox = $(this).find('input[name="gdpr"]');
                var canSubmit = true;

                if (emailField.length && emailField.prop('required') && emailField.val().trim() === '') {
                    // A more robust email validation regex could be used here if needed for client-side.
                    // For now, just checking if it's empty if required.
                    canSubmit = false;
                }
                // Very basic email format check - doesn't cover all cases but catches common mistakes
                if (emailField.length && emailField.val().trim() !== '' && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(emailField.val())) {
                     canSubmit = false;
                }


                if (gdprCheckbox.length && gdprCheckbox.prop('required') && !gdprCheckbox.is(':checked')) {
                    canSubmit = false;
                }

                if (!canSubmit) {
                    // If basic client-side validation fails, don't send the analytics event yet.
                    // The form submission will likely be blocked by the browser or handled by server-side validation feedback.
                    return; 
                }

                // Use file_name from localized data for the 'file' parameter
                var eventData = {
                    'file': spdfedAnalyticsData.file_name,
                    'post_id': spdfedAnalyticsData.post_id // Keep post_id for potentially more detailed tracking
                };

                if (spdfedAnalyticsData.type === 'ga4') {
                    if (typeof gtag === 'function') {
                        // GA4 event name: 'download_pdf', parameters: { file: 'example.pdf', post_id: 123 }
                        gtag('event', spdfedAnalyticsData.event_name, eventData);
                        // console.log('GA4 event sent: ', spdfedAnalyticsData.event_name, eventData);
                    } else {
                        // console.log('gtag function not found for GA4 event. Ensure GA4 is properly set up on your site.');
                    }
                } else if (spdfedAnalyticsData.type === 'gtm') {
                    window.dataLayer = window.dataLayer || [];
                    // GTM event: { event: 'secure_pdf_download', file: 'example.pdf', post_id: 123 }
                    var gtmPayload = {
                        'event': spdfedAnalyticsData.event_name,
                        // Add all properties from eventData to the GTM payload
                    };
                    for (var key in eventData) {
                        if (eventData.hasOwnProperty(key)) {
                            gtmPayload[key] = eventData[key];
                        }
                    }
                    dataLayer.push(gtmPayload);
                    // console.log('GTM event sent: ', gtmPayload);
                }
            });
        } else {
            // console.log('SPDFED: Download form not found for analytics binding.');
        }
    }
});
// PREMIUM END
